//========================================================================================
//===FADE IN FUNCTIONS===
//From when you touch an enemy to when you can control the menu.
//========================================================================================
//fade everything to black
function doBattleStartTransition1(%enemies)
{
	%fade = getWord($Player.getBlendColour(), 3);
	if(%fade == 0.000000)
	{
		doBattleStartTransition2(%enemies);
		return;
	}
	
	%alpha = %fade - 0.05;
	
	%x1 = getWord(sceneWindow2D.getCurrentCameraArea(), 0);
	%y1 = getWord(sceneWindow2D.getCurrentCameraArea(), 1);
	%x2 = getWord(sceneWindow2D.getCurrentCameraArea(), 2);
	%y2 = getWord(sceneWindow2D.getCurrentCameraArea(), 3);
	
	%list = $Player.scenegraph.pickRect(%x1, %y1, %x2, %y2, BIT(0) | BIT(1) | BIT(2), -1, 1, $Player);
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		%obj.setBlendColour("1 1 1 " @ %alpha);
	}
	
	sceneWindow2D.setCurrentCameraZoom(sceneWindow2D.getCurrentCameraZoom() + 0.05);
	
	$Player.setBlendColour("1 1 1 " @ %alpha);
	
	if(%alpha > 0)
		$transSched = schedule(30, 0, "doBattleStartTransition1", %enemies);
	else
		$transSched = schedule(110, 0, "doBattleStartTransition1", %enemies);
}

//hide everything and reset color blending
function doBattleStartTransition2(%enemies)
{
	%x1 = getWord(sceneWindow2D.getCurrentCameraArea(), 0);
	%y1 = getWord(sceneWindow2D.getCurrentCameraArea(), 1);
	%x2 = getWord(sceneWindow2D.getCurrentCameraArea(), 2);
	%y2 = getWord(sceneWindow2D.getCurrentCameraArea(), 3);
	
	%list = $Player.scenegraph.pickRect(%x1, %y1, %x2, %y2, BIT(0) | BIT(1) | BIT(2), -1, 1, $Player);
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		%obj.setVisible(0);
		%obj.setBlendColour("1 1 1 1");
	}
	
	$Player.setVisible(0);
	$Player.setBlendColour("1 1 1 0");
	
	startBattlePhase2(%enemies);
}


function doBattleFadeIn()
{
	$battleBackground.setBlendColour("1 1 1 " @ getWord($battleBackground.getBlendColour(), 3) + 0.05);
	$bPlayer.setBlendColour("1 1 1 " @ getWord($bPlayer.getBlendColour(), 3) + 0.05);
	for(%i = 0; %i < enemyGroup.getCount(); %i++)
	{
		enemyGroup.getObject(%i).setBlendColour("1 1 1 " @ getWord($enemy[%i].getBlendColour(), 3) + 0.05);
	}
	
	if(sceneWindow2D.getCurrentCameraZoom() != 1)
		sceneWindow2D.setCurrentCameraZoom(sceneWindow2D.getCurrentCameraZoom() - 0.05);
	
	if($battleBackground.getBlendColour() !$= "1.000000 1.000000 1.000000 1.000000")
	{
		$fadeInSched = schedule(32, 0, "doBattleFadeIn");
	}else{
		toggleBattleGui(1);
		schedule(500, 0, "startBattlePhase3");
	}
}

//========================================================================================
//===FADE OUT FUNCTIONS===
//From when you win the battle to when you can move again.
//========================================================================================

function doBattleFadeOut()
{
	$battleBackground.setBlendColour("1 1 1 " @ getWord($battleBackground.getBlendColour(), 3) - 0.05);
	$Player.setBlendColour("1 1 1 " @ getWord($Player.getBlendColour(), 3) + 0.05);
	$bPlayer.setBlendColour("1 1 1 " @ getWord($bPlayer.getBlendColour(), 3) - 0.05);
	
	for(%i = 0; %i < worldEnemyGroup.getCount(); %i++)
	{
		worldEnemyGroup.getObject(%i).setBlendColour("1 1 1 " @ getWord(worldEnemyGroup.getObject(%i).getBlendColour(), 3) + 0.5);
	}
	
	if(sceneWindow2D.getCurrentCameraZoom() != 1)
		sceneWindow2D.setCurrentCameraZoom(sceneWindow2D.getCurrentCameraZoom() - 0.05);
	
	if($battleBackground.getBlendColour() !$= "1.000000 1.000000 1.000000 0.000000")
	{
		$fadeInSched = schedule(32, 0, "doBattleFadeOut");
	}else{
		returnFromBattle2();
	}
}

function returnFromBattle1()
{
	if(!$battleInProgress)
	{
		error("tried to end a non-existing battle!");
		return;
	}
	
	$justLeftBattle = 1;
	$playerBlinkSched = schedule(300, 0, "blinkPlayer");
	
	for(%i = 0; %i < worldEnemyGroup.getCount(); %i++)
	{
		worldEnemyGroup.getObject(%i).moveTo(worldEnemyGroup.getObject(%i).getPosition(), 1);
		worldEnemyGroup.getObject(%i).setCollisionActive(0, 1);
	}
	schedule(4000, 0, "resetJustLeftBattle");
	
	$allowBattleClose = 0;
	alxStopAll();
	$battleMenuActive = 0;
	setButtonStates();
	toggleBattleGui(1);
	
	$targetMarker.delete();
	$powerHitIndicator.delete();
	
	%x1 = getWord(sceneWindow2D.getCurrentCameraArea(), 0);
	%y1 = getWord(sceneWindow2D.getCurrentCameraArea(), 1);
	%x2 = getWord(sceneWindow2D.getCurrentCameraArea(), 2);
	%y2 = getWord(sceneWindow2D.getCurrentCameraArea(), 3);
	
	%list = $Player.scenegraph.pickRect(%x1, %y1, %x2, %y2, BIT(0) | BIT(1) | BIT(2), -1, 1, $Player);
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		%obj.setBlendColour("1 1 1 1");
		%obj.setVisible(1);
	}
	
	for(%i = 0; %i < enemyGroup.getCount(); %i++)
	{
		enemyGroup.getObject(%i).safeDelete();
	}
	
	$Player.setBlendColour("1 1 1 0");
	$Player.visible = 1;
	$battleInProgress = 0;
	sceneWindow2D.setCurrentCameraZoom(1.95);
	doBattleFadeOut();
}

function blinkPlayer()
{
	%alpha = getWord($Player.getBlendColour(), 3);
	if(%alpha == 1)
		$Player.setBlendColour("1 1 1 0.25");
	else
		$Player.setBlendColour("1 1 1 1");
		
	$playerBlinkSched = schedule(200, 0, "blinkPlayer");
}

function resetJustLeftBattle()
{
	for(%i = 0; %i < worldEnemyGroup.getCount(); %i++)
	{
		worldEnemyGroup.getObject(%i).setCollisionActive(1, 1);
	}
	cancel($playerBlinkSched);
	$Player.setBlendColour("1 1 1 1");
	$justLeftBattle = 0;
}

function returnFromBattle2()
{
	$battleBackground.delete();
	$bPlayer.delete();
	alxPlay(gameMusic);
}
